// author: RuanShengQiang 
// date: 2017/6/1
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, 1.0f - tc.y));
}

float _abs(float a)
{
	if(a<0)
		return -a;
	else
		return a;
}


__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dstImg,__global FilterParam* param)
{
	//const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;
	float minImgSize = 5.f;
	float progress = param->cur_time / param->total_time;
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[2];
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;
	
	vec4 color;
	vec2 p = tc;
	float i = fragCoord.y;
	float j = fragCoord.x;
	float width = resolution.x;
	float height = resolution.y;
	  if (progress >= 1.0f)
	  {
		color = INPUT(input2, param, (vec2)(p));
	  }
	  else
	  {
		float dFromImgScale = 1.f + 10.f * progress;
		float FromI = (fragCoord.y - resolution.y / 2.f) / dFromImgScale + resolution.y / 2.f;
		  float FromJ = (fragCoord.x- resolution.x / 2.f) / dFromImgScale + resolution.x / 2.f;
		color = INPUT(input1, param,(vec2)(FromJ / resolution.x, FromI / resolution.y));
		
		float dToImgScale = progress;
		float rectToImg_width = resolution.x * dToImgScale;
		  float rectToImg_height = resolution.y * dToImgScale;
		  float rectToImg_x = (resolution.x - rectToImg_width) / 2.f;
		float rectToImg_y = (resolution.y - rectToImg_height) / 2.f;
		if (rectToImg_width > minImgSize)
		{
		  if (_abs(i - resolution.y / 2.f) < rectToImg_height / 2.f &&
						_abs(j - resolution.x / 2.f) < rectToImg_width / 2.f) 
					{
					  float ToI = (i - height / 2.f) / dToImgScale + height / 2.f;
						float ToJ = (j - width / 2.f) / dToImgScale + width / 2.f;
						color = INPUT(input2, param, (vec2)(ToJ / resolution.x, ToI / resolution.y));
					}
		}
	  }
	write_imagef(dstImg, (int2)(w, textH - h -1), color);
}